﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using RevisionAnalyser.Global;
using System.IO;
using SharpSvn;
using RevisionAnalyser.Controls;

namespace RevisionAnalyser.Projects.RecoderProject
{
    public partial class SettingsForm : LoadableForm
    {
        private RecoderProject _project = (RecoderProject)CurrentProject.Instance.Project;

        public SettingsForm()
        {
            InitializeComponent();
        }

        private void SvnDetailsForm_Load(object sender, EventArgs e)
        {
            uxUrlField.Text = _project.SvnUrl;
            uxUsernameField.Text = _project.SvnUsername;
            uxPasswordField.Text = _project.SvnPassword;
            AddLibraryLocations(_project.JarLocations.ToArray());
        }

        public DialogResult ShowDialog(int tabNumber, bool hideOtherTabs)
        {
            if (hideOtherTabs)
            {
                uxTabControl.TabPages.Clear();
                uxTabControl.TabPages.Add(uxTabLibraries);
            }
            else
            {
                uxTabControl.SelectedIndex = tabNumber;
            }
            return ShowDialog();
        }

        public string GetUrl()
        {
            return uxUrlField.Text;
        }

        public string GetUsername()
        {
            return uxUsernameField.Text;
        }

        public string GetPassword()
        {
            return uxPasswordField.Text;
        }

        public List<string> GetLibraryLocations()
        {
            List<string> locations = new List<string>();
            foreach (ListViewItem item in uxLibraryView.Items)
            {
                locations.Add(item.Text);
            }
            return locations;
        }

        private void AddLibraryLocations(string[] locations)
        {
            List<string> curFiles = GetLibraryLocations();
            foreach (string file in locations)
            {
                if (!curFiles.Contains(file))
                {
                    uxLibraryView.Items.Add(new ListViewItem(file));
                }
            }
        }

        private void AddLibraryLocations()
        {
            if (uxOpenJarDialog.ShowDialog() == DialogResult.OK)
            {
                AddLibraryLocations(uxOpenJarDialog.FileNames);
            }
        }

        private void AddLibraryFolder()
        {
            if (uxOpenJarFolderDialog.ShowDialog() == DialogResult.OK)
            {
                AddLibraryLocations(new string[] { uxOpenJarFolderDialog.SelectedPath });
            }
        }

        private void TestConnection()
        {
            using (SvnClient client = _project.GetSvnClient(GetUsername(), GetPassword()))
            {
                try
                {
                    ShowLoadScreen("Connecting to SVN...");
                    SvnInfoEventArgs args;
                    client.GetInfo(new SvnUriTarget(GetUrl()), out args);
                    TopMostMessageBox.Show("Connection succeeded.", "Success", MessageBoxButtons.OK, MessageBoxIcon.Information);
                }
                catch (Exception ex)
                {
                    TopMostMessageBox.Show(String.Format("Could not connect to the SVN server.\n\n{0}", ex.Message), "SVN connection error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
                finally
                {
                    HideLoadScreen();
                }
            }
        }

        private void uxOKButton_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
            Close();
        }

        private void uxCancelButton_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void uxShowPasswordBox_CheckedChanged(object sender, EventArgs e)
        {
            uxPasswordField.UseSystemPasswordChar = !uxShowPasswordBox.Checked;
        }

        private void uxLibraryAddFileButton_Click(object sender, EventArgs e)
        {
            AddLibraryLocations();
        }

        private void uxLibraryAddFolderButton_Click(object sender, EventArgs e)
        {
            AddLibraryFolder();
        }

        private void uxLibraryView_SelectedIndexChanged(object sender, EventArgs e)
        {
            uxLibraryDeleteButton.Enabled = uxLibraryView.SelectedItems.Count > 0;
        }

        private void uxLibraryDeleteButton_Click(object sender, EventArgs e)
        {
            foreach (ListViewItem item in uxLibraryView.SelectedItems)
            {
                uxLibraryView.Items.Remove(item);
            }
            uxLibraryView_SelectedIndexChanged(sender, e);
        }

        private void SettingsForm_Resize(object sender, EventArgs e)
        {
            uxLocationHeader.Width = Width - 110;
        }

        private void uxTestConnectionButton_Click(object sender, EventArgs e)
        {
            TestConnection();
        }
    }
}
